package {
	
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Face;
	import away3d.core.base.Mesh;
	import away3d.core.base.Object3D;
	import away3d.events.LoaderEvent;
	import away3d.lights.DirectionalLight3D;
	import away3d.loaders.Collada;
	import away3d.loaders.Object3DLoader;
	import away3d.materials.BitmapMaterial;
	import away3d.materials.ColorMaterial;
	import away3d.materials.ShadingColorMaterial;
	import away3d.materials.WhiteShadingBitmapMaterial;
	import away3d.materials.WireColorMaterial;
	import away3d.primitives.Cube;
	import away3d.primitives.Plane;
	
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyTimeline;
	
	import fl.motion.easing.Cubic;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageDisplayState;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Rectangle;
	import flash.system.Capabilities;
	import flash.system.System;
	import flash.system.fscommand;
	import flash.ui.Keyboard;
	
	import net.hires.debug.Stats;
	
	import org.libspark.thread.Thread;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class MainThread extends Thread {
		
		[Embed(source='../assets/camera_para.dat', mimeType='application/octet-stream')]
		private static const cameraDataClass:Class;
		[Embed(source='../assets/flarlogo.pat', mimeType='application/octet-stream')]
		private static const patterDataClass:Class;
		[Embed(source='../assets/info.png')]
		private static const infoImageClass:Class;
		
		private var _ctx:Context;
		private var _info:Sprite;
		private var _currentDemo:IDemoThread;
		private var _index:int = 0;
		private var _binaryImage:Bitmap;
		private var _stats:Stats;
		
		private static const DEMOS:Array = [
			LogoLogoDemo,
			ClothSimuDemo,
			HachuneDemo,
			HoleDemo,
		];
		
		public function MainThread(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
			this._init();
		}
		
		private function _init():void {
			//
			DisplayShortcuts.init();
			
			// stage
			this._ctx.stage.quality = StageQuality.LOW;
			var a:Number = Capabilities.screenResolutionY / Capabilities.screenResolutionX;
			var rect:Rectangle = new Rectangle(0, 0, 640, 640 * a);
			rect.x = (640 - rect.width) / 2;
			rect.y = (480 - rect.height) / 2;
			this._ctx.stage.fullScreenSourceRect = rect;
			fscommand('fullscreen', 'true');

			// arview
			this._ctx.arview = this._ctx.stage.addChild(new AwayFLARView3D({
				x:320 + 5, y:240,
				param: new cameraDataClass(),
				code: new patterDataClass(),
				threshold: 128,
				continueMode: false
			})) as AwayFLARView3D;
			this._ctx.arview.scaleX = -2.0;
			this._ctx.arview.scaleY = 2.0;
			var bm:Bitmap = this._ctx.stage.addChildAt(this._ctx.arview.captureImage, 0) as Bitmap;
			bm.scaleX = -2.0;
			bm.scaleY = 2.0;
			bm.x = 640;
			bm.y = 0;

			// 3d
			var light:DirectionalLight3D = new DirectionalLight3D({x:0, y:100, z:-100, brightness:3});
			this._ctx.arview.scene.addChild(light);
			this._ctx.renderThread = new RenderThread(this._ctx);
			this._ctx.renderThread.start();
			
			// info
			this._info = this._ctx.stage.addChild(new Sprite()) as Sprite;
			this._info.y = rect.y;
			this._info.addChild(new infoImageClass());
			
			this._binaryImage = this._ctx.stage.addChild(new Bitmap(this._ctx.arview.binaryImage)) as Bitmap;
			this._binaryImage.scaleX = this._binaryImage.scaleY = 2.0;
			this._binaryImage.visible = false;
			
			// debug
//			this._stats = this._ctx.stage.addChild(new Stats(this._ctx.arview, 60)) as Stats;
			this._stats = this._ctx.stage.addChild(new Stats()) as Stats;
//			this._stats.displayStats(null);
			this._stats.y = rect.y;
			this._stats.alpha = 0.5;
			this._stats.visible = false;

			next(this._event);
		}
		
		private function _event():void {
			event(this._ctx.stage, MouseEvent.CLICK, this._onStageClick);
			event(this._ctx.stage, KeyboardEvent.KEY_DOWN, this._onKeyDown);
			event(this._ctx.arview, Event.CHANGE, this._onStateChange);
		}
		
		private function _onStageClick(e:Event = null):void {
			this._ctx.stage.displayState = this._ctx.stage.displayState == StageDisplayState.FULL_SCREEN ? StageDisplayState.NORMAL : StageDisplayState.FULL_SCREEN;
			next(this._event);
		}
		
		private function _onStateChange(e:Event):void {
			Tweener.addTween(this._info, {
				_autoAlpha: this._ctx.arview.detected ? 0 : 1,
				time: 1
			});
			if (this._ctx.arview.detected) {
				var demokls:Class = DEMOS[this._index];
				this._currentDemo = new demokls(this._ctx);
				this._currentDemo.start();
				if (++this._index == DEMOS.length) {
					this._index = 0;
				}
			} else {
				if (this._currentDemo) {
					this._currentDemo.close();
					this._currentDemo = null;
				}
			}
			next(this._event);
		}
		
		private function _onKeyDown(e:KeyboardEvent):void {
//			trace(e);
			switch (e.keyCode) {
				case Keyboard.UP:
					this._ctx.arview.threshold = Math.min(255, this._ctx.arview.threshold + 8);
					this._showBinary();
					break;
				case Keyboard.DOWN:
					this._ctx.arview.threshold = Math.max(0, this._ctx.arview.threshold - 8);
					this._showBinary();
					break;
			}
			switch (e.charCode) {
				case 115:
					this._stats.visible = !this._stats.visible;
					break;
			}
			trace(this._ctx.arview.threshold);
			next(this._event);
		}
		
		private function _showBinary():void {
			Tweensy.stop(this._binaryImage);
			this._binaryImage.visible = true;
			this._binaryImage.alpha = 1.0;
			var tl:TweensyTimeline = Tweensy.to(this._binaryImage, {alpha:0}, 0.5, Cubic.easeInOut, 1);
			tl.onComplete = function ():void {
				_binaryImage.visible = false;
			}
		}
	}
}